using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CannibalProblem;

namespace CannibalProblem
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            comboBox_initBoatPosition.SelectedIndex = 0;
            comboBox_goalBoatPosition.SelectedIndex = 0;
        }

        private void button_solve_Click(object sender, EventArgs e)
        {
            CannibalState initState, goalState;
            CannibalSolver solver;
            CannibalState.Position pos;
            int lcannibals, rcannibals, lmissionaries, rmissionaries, boatSize;
            boatSize = (int)numericUpDown_boatSize.Value;
            if ((string)comboBox_initBoatPosition.SelectedItem == "Left")
                pos = CannibalState.Position.Left;
            else
                pos = CannibalState.Position.Right;
            lcannibals = (int)numericUpDown_initLeftCannibals.Value;
            rcannibals = (int)numericUpDown_initRightCannibals.Value;
            lmissionaries = (int)numericUpDown_initLeftMissionaries.Value;
            rmissionaries = (int)numericUpDown_initRightMissionaries.Value;
            initState = new CannibalState(pos, lcannibals, lmissionaries, rcannibals, rmissionaries);
            if ((string)comboBox_goalBoatPosition.SelectedItem == "Left")
                pos = CannibalState.Position.Left;
            else
                pos = CannibalState.Position.Right;
            lcannibals = (int)numericUpDown_goalLeftCannibals.Value;
            rcannibals = (int)numericUpDown_goalRightCannibals.Value;
            lmissionaries = (int)numericUpDown_goalLeftMissionaries.Value;
            rmissionaries = (int)numericUpDown_goalRightMissionaries.Value;
            goalState = new CannibalState(pos, lcannibals, lmissionaries, rcannibals, rmissionaries);
            try
            {
                solver = new CannibalSolver(initState, goalState, boatSize);
            }
            catch
            {
                MessageBox.Show("Invalid init state or invalid goal state or boat size is less than 2.", 
                    "Invalid Inputs", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }
            this.Text = "Cannibal and Missionary Problem Solver(Solving...)";
            List<string> tempList = solver.BFS();
            listBox1.Items.Clear();
            if (tempList == null)
                listBox1.Items.Add("This Problem has no Soloution.");
            else
                foreach (string str in tempList)
                    listBox1.Items.Add(str);
            label_visitedNodes.Text = "Visited Nodes: " + solver.VisitedNodes.ToString();
            label_visitedDistinctNodes.Text = "visited Distinct Nodes: " + solver.VisitedDistinctNodes.ToString();
            label_Steps.Text = "Number of Steps: " + (tempList == null ? 0 : tempList.Count);
            this.Text = "Cannibal and Missionary Problem Solver";
        }
    }
}